-- walking
local expectedDirs = {}
local isWalking = {}
local walkPath = {}
local walkPathIter = 0
local autoWalking = false

local function cfg(id, fallback)
  if CaveBot.Config and CaveBot.Config.values and CaveBot.Config.values[id] ~= nil then
    return CaveBot.Config.values[id]
  end
  return fallback
end

local function maxQueueSize()
  if cfg("fastWalk", true) and not cfg("mapClick") then
    return 6
  end
  return 3
end

local function walkDelayMs(dir, opts)
  if cfg("fastWalk", true) then return 0 end
  local stepDuration = player:getStepDuration(false, dir) or 0
  local extra = 0

  if opts and opts.useMapClickDelay then
    extra = extra + cfg("mapClickDelay", 0)
  else
    extra = extra + cfg("walkDelay", 0)
  end

  if opts and opts.includePing then
    extra = extra + cfg("ping", 0)
  end

  if opts and opts.extra then
    extra = extra + opts.extra
  end

  return extra + stepDuration
end

local function mapClickStartDelay(dir)
  if cfg("fastWalk", true) then return 0 end
  local stepDuration = player:getStepDuration(false, dir) or 0
  local base = math.max(cfg("ping", 0) + stepDuration, stepDuration * 2)
  return cfg("mapClickDelay", 0) + base
end

CaveBot.resetWalking = function()
  expectedDirs = {}
  walkPath = {}
  isWalking = false
  autoWalking = false
end

CaveBot.doWalking = function()
  if cfg("mapClick") or autoWalking then
    return false
  end
  if #expectedDirs == 0 then
    return false
  end
  if #expectedDirs >= maxQueueSize() then
    CaveBot.resetWalking()
  end
  local dir = walkPath[walkPathIter]
  if dir then
    g_game.walk(dir, false)
    table.insert(expectedDirs, dir)
    walkPathIter = walkPathIter + 1
    CaveBot.delay(walkDelayMs(dir))
    return true
  end
  return false
end

-- called when player position has been changed (step has been confirmed by server)
onPlayerPositionChange(function(newPos, oldPos)
  if not oldPos or not newPos then return end

  local dirs = {{NorthWest, North, NorthEast}, {West, 8, East}, {SouthWest, South, SouthEast}}
  local dir = dirs[newPos.y - oldPos.y + 2]
  if dir then
    dir = dir[newPos.x - oldPos.x + 2]
  end
  if not dir then
    dir = 8 -- 8 is invalid dir, it's fine
  end

  if not isWalking or not expectedDirs[1] then
    -- some other walk action is taking place (for example use on ladder), wait
    walkPath = {}
    CaveBot.delay(walkDelayMs(dir, {includePing=true, extra=150}))
    return
  end

  if expectedDirs[1] ~= dir then
    local opts = cfg("mapClick") and {useMapClickDelay=true} or nil
    CaveBot.delay(walkDelayMs(dir, opts))
    return
  end

  table.remove(expectedDirs, 1)
  if cfg("mapClick") and #expectedDirs > 0 then
    CaveBot.delay(walkDelayMs(dir, {useMapClickDelay=true}))
  end
  if #expectedDirs == 0 then
    isWalking = false
    autoWalking = false
  end
end)

CaveBot.walkTo = function(dest, maxDist, params)
  local path = getPath(player:getPosition(), dest, maxDist, params)
  if not path or not path[1] then
    return false
  end
  local dir = path[1]

  local useAutoWalk = cfg("mapClick") or (cfg("fastWalk", true) and not cfg("mapClick"))

  if useAutoWalk then
    local ret = autoWalk(path)
    if ret then
      autoWalking = true
      isWalking = true
      expectedDirs = path
      CaveBot.delay(mapClickStartDelay(dir))
    end
    return ret
  end

  g_game.walk(dir, false)
  isWalking = true
  walkPath = path
  walkPathIter = 2
  expectedDirs = { dir }
  CaveBot.delay(walkDelayMs(dir))
  return true
end
